<?php

/*
	Plugin Name: Download Monitor - Downloading Page
	Plugin URI: https://www.download-monitor.com/
	Description: The Downloading Page extension for Download Monitor forces your downloads to be served from a separate page.
	Version: 4.1.1
	Author: WPChill
	Author URI: https://wpchill.com
	License: GPL v3
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class DLM_Downloading_Page {

	const VERSION = '4.1.1';

	public function __construct() {

		// Create Downloading Page on plugin activation.
		//	$downloading_page = new DLM_DP_Page();.

		// Download Access Manager.
		$access_manager = new DLM_DP_Access_Manager();
		$access_manager->setup();

		// Register Shortcode.
		$shortcode = new DLM_DP_Shortcode();
		$shortcode->setup();
		// Register Extension.
		add_filter( 'dlm_extensions', array( $this, 'register_extension' ) );
		// Admin only classes.
		if ( is_admin() ) {

			add_action( 'admin_notices', array( $this, 'admin_notices' ), 8 );
			// Add filter for compatibility, will be removed migration has been done.
			add_filter( 'dlm_disable_update_for_dlm-downloading-page', '__return_false', 15 );
			if ( ! $this->check_functionality() ) {
				return;
			}
			// add settings.
			add_filter( 'dlm_settings', array( 'DLM_DP_Settings', 'add_settings' ) );
		}
	}

	/**
	 * Get the plugin file
	 *
	 * @static
	 *
	 * @return String
	 */
	public static function get_plugin_file() {
		return __FILE__;
	}

	/**
	 * Register this extension
	 *
	 * @param array $extensions
	 *
	 * @return array $extensions
	 */
	public function register_extension( $extensions ) {

		$extensions[] = array(
			'file'    => 'dlm-downloading-page',
			'version' => self::VERSION,
			'name'    => 'Downloading Page'
		);

		return $extensions;
	}

	/**
	 * Display admin notices
	 *
	 * @return void
	 */
	public function admin_notices() {

		if ( ! class_exists( 'WP_DLM' ) ) {
			?>
			<div class="error">
				<p><?php _e( 'Download Monitor - Downloading Page requires Download Monitor to work.', 'dlm-downloading-page' ); ?></p>
			</div>
			<?php
		}

	}

	/**
	 * Check extensions functionality
	 *
	 * @return bool
	 *
	 * @since 4.0.6
	 */
	public function check_functionality() {
		if ( class_exists( 'DLM_Admin_Helper' ) ) {
			$admin_helper = DLM_Admin_Helper::get_instance();
			if ( method_exists( $admin_helper, 'check_license_validity' ) ) {
				if ( ! $admin_helper->check_license_validity( 'dlm-downloading-page' ) ) {
					return false;
				}
			}
		}

		return true;
	}
}

require_once dirname( __FILE__ ) . '/vendor/autoload_52.php';
define( 'DLM_DWNP_PATH', plugin_dir_path( __FILE__ ) );
define( 'DLM_DWNP_URL', plugin_dir_url( __FILE__ ) );
define( 'DLM_DWNP_FILE', __FILE__ );

function __dlm_downloading_page() {

	require_once __DIR__ . '/includes/Product/class-dlm-product-child.php';
	require_once __DIR__ . '/includes/class-dlm-extensions-notices.php';
	require_once __DIR__ . '/includes/PROInstall/class-dlm-pro-install.php';
	load_plugin_textdomain( 'dlm-downloading-page', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	new DLM_Downloading_Page();
}

function dlm_dp_plugin_activated(){

	if( 0 == absint( get_option( DLM_DP_Constants::SETTING_PAGE, 0 ) ) ){

		$downloading_page = array(
			'post_title'    => 'Download Page',
			'post_status'   => 'publish',
			'post_author'   => 1,
			'post_type' => 'page',
			'post_content' => '[dlm_downloading_page]'
			);

		$downloading_page_id = wp_insert_post( $downloading_page );

		update_option( DLM_DP_Constants::SETTING_PAGE, $downloading_page_id );
	}
}
register_activation_hook( DLM_DWNP_FILE ,'dlm_dp_plugin_activated' );

add_action( 'plugins_loaded', '__dlm_downloading_page', 11 );

register_activation_hook( __FILE__, 'dlm_downloading_page_activate_plugin' );

register_deactivation_hook( __FILE__, 'dlm_downloading_page_deactivate_plugin' );

function dlm_downloading_page_deactivate_plugin() {
	// Deactivate extension license if exists.
	if ( class_exists( 'DLM_PRO_Extensions_Handler' ) ) {
		$extensions = DLM_PRO_Extensions_Handler::get_instance();
		$extensions->handle_extension_action( 'deactivate', array(
			'slug' => 'dlm-downloading-page',
			'name' => 'Downloading Page'
		) );
	}
}

function dlm_downloading_page_activate_plugin() {

	// Activate extension license if exists.
	if ( class_exists( 'DLM_PRO_Extensions_Handler' ) ) {
		$extensions = DLM_PRO_Extensions_Handler::get_instance();
		$extensions->handle_extension_action( 'activate', array(
			'slug' => 'dlm-downloading-page',
			'name' => 'Downloading Page'
		) );
	}
}