<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Xolio Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_IconList extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'iconlist';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Icon List', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tg_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                    'layout-2' => esc_html__('Layout 2', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // _tg_list
        $this->start_controls_section(
            '_tg_icon_list',
            [
                'label' => esc_html__('Icon List', 'tpcore'),
                'condition' => [
                    'tg_design_style' => 'layout-1'
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tg_svg',
            [
                'label' => esc_html__('Upload Icon', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'icon_text',
            [
                'label' => esc_html__('Icon Text', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('12x', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'repeater_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Faster Order Processing', 'tpcore'),
                'placeholder' => esc_html__('Type list text', 'tpcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'item_lists',
            [
                'label' => esc_html__('Item Lists', 'tpcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'repeater_title' => esc_html__('Faster Order Processing', 'tpcore'),
                    ],
                    [
                        'repeater_title' => esc_html__('Processing Accuracy', 'tpcore'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // _tg_list
        $this->start_controls_section(
            '_tg_icon_list2',
            [
                'label' => esc_html__('Icon List', 'tpcore'),
                'condition' => [
                    'tg_design_style' => 'layout-2'
                ]
            ]
        );

        $repeater2 = new \Elementor\Repeater();

        $repeater2->add_control(
            'tg_svg2',
            [
                'label' => esc_html__('Upload Icon', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater2->add_control(
            'icon_text2',
            [
                'label' => esc_html__('Sub Text', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Name:', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater2->add_control(
            'repeater_title2',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Jams Robot', 'tpcore'),
                'placeholder' => esc_html__('Type list text', 'tpcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'item_lists2',
            [
                'label' => esc_html__('Item Lists', 'tpcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater2->get_controls(),
                'default' => [
                    [
                        'repeater_title2' => esc_html__('Jams Robot', 'tpcore'),
                    ],
                    [
                        'repeater_title2' => esc_html__('jamsrobot@email.com', 'tpcore'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'tpcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'tpcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'tpcore'),
                    'lowercase' => esc_html__('lowercase', 'tpcore'),
                    'capitalize' => esc_html__('Capitalize', 'tpcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

?>

        <?php if ($settings['tg_design_style'] == 'layout-2') : ?>

            <div class="developer-info-wrap">
                <ul class="list-wrap">
                    <?php foreach ($settings['item_lists2'] as $item) : ?>
                        <li>
                            <?php if (!empty($item['tg_svg2']['url'])) : ?>
                                <div class="icon">
                                    <img src="<?php echo tp_kses($item['tg_svg2']['url']); ?>" alt="<?php echo esc_attr__('Image', 'tpcore') ?>">
                                </div>
                            <?php endif; ?>

                            <div class="content">
                                <?php if (!empty($item['icon_text2'])) : ?>
                                    <span><?php echo tp_kses($item['icon_text2']); ?></span>
                                <?php endif; ?>

                                <?php if (!empty($item['repeater_title2'])) : ?>
                                    <p><?php echo tp_kses($item['repeater_title2']); ?></p>
                                <?php endif; ?>
                            </div>

                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>

        <?php else : ?>

            <div class="consultation-list">
                <ul class="list-wrap">
                    <?php foreach ($settings['item_lists'] as $item) : ?>
                        <li>
                            <?php if (!empty($item['tg_svg']['url'])) : ?>
                                <div class="icon">
                                    <img src="<?php echo tp_kses($item['tg_svg']['url']); ?>" alt="<?php echo esc_attr__('Image', 'tpcore') ?>">
                                    <span><?php echo esc_html( $item['icon_text'] ) ?></span>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($item['repeater_title'])) : ?>
                                <div class="content">
                                    <h6 class="title"><?php echo tp_kses($item['repeater_title']); ?></h6>
                                </div>
                            <?php endif; ?>

                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>

        <?php endif; ?>

<?php
    }
}

$widgets_manager->register(new TG_IconList());
