<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Xolio Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_History extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tp-history';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Our History', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // tg_history_section
        $this->start_controls_section(
            'tg_history_section',
            [
                'label' => esc_html__('History List', 'tpcore'),
            ]
        );

        $this->add_control(
            'hide_shape',
            [
                'label' => esc_html__('Show Shape', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tpcore'),
                'label_off' => esc_html__('Hide', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'tg_year',
            [
                'label' => esc_html__('Year', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('2020', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tg_history_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('January 14 th', 'tpcore'),
                'placeholder' => esc_html__('Enter Title Text', 'tpcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_history_items',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => esc_html__('History Items', 'tpcore'),
                'default' => [
                    [
                        'tg_year' => esc_html__('2020', 'tpcore'),
                        'tg_history_title' => esc_html__('January 14 th', 'tpcore'),
                    ],
                    [
                        'tg_year' => esc_html__('2021', 'tpcore'),
                        'tg_history_title' => esc_html__('November 14 th', 'tpcore'),
                    ],
                    [
                        'tg_year' => esc_html__('2022', 'tpcore'),
                        'tg_history_title' => esc_html__('February 15 th', 'tpcore'),
                    ],
                    [
                        'tg_year' => esc_html__('2023', 'tpcore'),
                        'tg_history_title' => esc_html__('January 16 th', 'tpcore'),
                    ],
                ]
            ]
        );

        $this->end_controls_section();

        // STYLE TAB
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'tpcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'tpcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'tpcore'),
                    'lowercase' => esc_html__('lowercase', 'tpcore'),
                    'capitalize' => esc_html__('Capitalize', 'tpcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>

        <div class="history-roadmap-wrap">
            <?php if(!empty( $settings['hide_shape'] )) : ?>
            <div class="roadmap-line-shape">
                <span class="dot-one pulse-one"></span>
                <span class="dot-two pulse-two"></span>
            </div>
            <?php endif; ?>
            <ul class="list-wrap">
                <?php $is_active = 0; foreach ($settings['tg_history_items'] as $item) : $is_active++; ?>
                    <li class="wow <?php echo $is_active % 2 ? 'fadeInDown' : 'fadeInUp' ?>" data-wow-delay=".2s" data-wow-duration="1.5s">
                        <span class="dot pulse-three"></span>
                        <div class="content">
                            <h5 class="title"><?php echo tp_kses($item['tg_year']) ?></h5>
                            <p><?php echo tp_kses($item['tg_history_title']) ?></p>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>

<?php
    }
}

$widgets_manager->register(new TG_History());
