<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Xolio Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_Project extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'project-list';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Project', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'tg_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tg_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                    'layout-2' => esc_html__('Layout 2', 'tpcore'),
                    'layout-3' => esc_html__('Layout 3', 'tpcore'),
                    'layout-4' => esc_html__('Layout 4', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // Service group
        $this->start_controls_section(
            'tg_project',
            [
                'label' => esc_html__('Project List', 'tpcore'),
                'description' => esc_html__('Control all the style settings from Style tab', 'tpcore'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tg_design_style' => ['layout-1', 'layout-4']
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tg_project_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                    'layout-2' => esc_html__('Layout 2', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $repeater->add_control(
            'tg_project_image',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => esc_html__('Image', 'tpcore'),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'tg_title_top',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type gallery title', 'tpcore'),
                'default' => esc_html__('Motion Design', 'tpcore'),
                'condition' => [
                    'tg_project_style' => 'layout-2',
                ]
            ]
        );

        $repeater->add_control(
            'tg_desc_top',
            [
                'label' => esc_html__('Description Text', 'tpcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Gorem Ipsum is simply', 'tpcore'),
                'title' => esc_html__('Enter button text', 'tpcore'),
                'label_block' => true,
                'condition' => [
                    'tg_project_style' => 'layout-2',
                ]
            ]
        );

        $repeater->add_control(
            'tg_project_url',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('URL', 'tpcore'),
                'default' => esc_html__('#', 'tpcore'),
                'placeholder' => esc_html__('Type url here', 'tpcore'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'tg_project_image02',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => esc_html__('Image', 'tpcore'),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'tg_project_style' => 'layout-2',
                ]
            ]
        );

        $repeater->add_control(
            'tg_title_bottom',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type gallery title', 'tpcore'),
                'default' => esc_html__('Motion Design', 'tpcore'),
                'condition' => [
                    'tg_project_style' => 'layout-2',
                ]
            ]
        );

        $repeater->add_control(
            'tg_desc_bottom',
            [
                'label' => esc_html__('Description Text', 'tpcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Gorem Ipsum is simply', 'tpcore'),
                'title' => esc_html__('Enter button text', 'tpcore'),
                'label_block' => true,
                'condition' => [
                    'tg_project_style' => 'layout-2',
                ]
            ]
        );

        $repeater->add_control(
            'tg_url_bottom',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('URL', 'tpcore'),
                'default' => esc_html__('#', 'tpcore'),
                'placeholder' => esc_html__('Type url here', 'tpcore'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'tg_project_style' => 'layout-2',
                ]
            ]
        );

        $this->add_control(
            'tg_project_list',
            [
                'label' => esc_html__('Project List', 'tpcore'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tg_project_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'tg_project_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'tg_project_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'tg_project_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'before',
                'exclude' => [
                    'custom'
                ]
            ]
        );

        $this->end_controls_section();

        // Project Two group
        $this->start_controls_section(
            'tg_project_tab',
            [
                'label' => esc_html__('Project Tab List', 'tpcore'),
                'description' => esc_html__('Control all the style settings from Style tab', 'tpcore'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tg_design_style' => 'layout-3'
                ]
            ]
        );

        $repeater2 = new \Elementor\Repeater();

        $repeater2->add_control(
            'tg_project_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Hosting Website Design', 'tpcore'),
            ]
        );

        $repeater2->add_control(
            'tg_project_desc',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('At Xolio we specialize in designing, building, shipping...', 'tpcore'),
            ]
        );

        $repeater2->add_control(
            'tg_project_image2',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => esc_html__('Image', 'tpcore'),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater2->add_control(
            'tg_project_btn',
            [
                'label' => esc_html__('Button Text', 'tpcore'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('View Case Studies', 'tpcore'),
            ]
        );

        $repeater2->add_control(
            'tg_project_url2',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Project URL', 'tpcore'),
                'default' => esc_html__('#', 'tpcore'),
                'placeholder' => esc_html__('Type url here', 'tpcore'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'tg_project_list2',
            [
                'label' => esc_html__('Project List', 'tpcore'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater2->get_controls(),
                'default' => [
                    [
                        'tg_project_image2' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'tg_project_image2' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'tg_project_image2' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'tg_project_image2' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'project_thumb',
                'default' => 'medium_large',
                'separator' => 'before',
                'exclude' => [
                    'custom'
                ]
            ]
        );

        $this->end_controls_section();

        // Tab Section
        $this->start_controls_section(
            '_section_gallery',
            [
                'label' => esc_html__('Portfolio Tabs', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tg_design_style' => 'layout-2'
                ]
            ]
        );

        $project = new \Elementor\Repeater();

        $project->add_control(
            'tg_gallery_col',
            [
                'label' => esc_html__('Select Post Columns', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    '4' => '4 Columns',
                    '6' => '6 columns',
                    '8' => '8 columns',
                ],
                'default' => '4',
            ]
        );

        $project->add_control(
            'tg_img',
            [
                'label' => esc_html__('Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $project->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'tg_image_size',
                'default' => 'full',
                'exclude' => [
                    'custom'
                ]
            ]
        );

        $project->add_control(
            'item_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type gallery title', 'tpcore'),
                'default' => esc_html__('Motion Design', 'tpcore'),
            ]
        );

        $project->add_control(
            'filter',
            [
                'label' => esc_html__('Filter Name (Category)', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type gallery filter name', 'tpcore'),
                'description' => esc_html__('Filter name will be used in filter menu. Added more category by , separator.', 'tpcore'),
                'default' => esc_html__('Filter Name', 'tpcore'),
                'label_block' => true,
            ]
        );

        $project->add_control(
            'tg_projects_desc',
            [
                'label' => esc_html__('Description Text', 'tpcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Gorem Ipsum is simply', 'tpcore'),
                'title' => esc_html__('Enter button text', 'tpcore'),
                'label_block' => true,
            ]
        );

        $project->add_control(
            'tg_projects_url',
            [
                'label' => esc_html__('Item URL', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'tpcore'),
                'title' => esc_html__('Enter button url', 'tpcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'gallery',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $project->get_controls(),
                'show_label' => false,
                'title_field' => sprintf(esc_html__('Filter Group: %1$s', 'tpcore'), '{{filter}}'),
                'default' => [
                    [
                        'images' => Utils::get_placeholder_image_src(),
                        'filter' => esc_html__('app', 'tpcore'),
                        'title' => esc_html__('Colorful Art Work', 'tpcore'),

                    ],
                    [
                        'images' => Utils::get_placeholder_image_src(),
                        'filter' => esc_html__('website', 'tpcore'),
                        'title' => esc_html__('Motion Design', 'tpcore'),

                    ],
                    [
                        'images' => Utils::get_placeholder_image_src(),
                        'filter' => esc_html__('landing-page', 'tpcore'),
                        'title' => esc_html__('Colorful Art Work', 'tpcore'),

                    ],
                    [
                        'images' => Utils::get_placeholder_image_src(),
                        'filter' => esc_html__('branding-app', 'tpcore'),
                        'title' => esc_html__('Motion Design', 'tpcore'),

                    ],
                    [
                        'images' => Utils::get_placeholder_image_src(),
                        'filter' => esc_html__('product-design', 'tpcore'),
                        'title' => esc_html__('Colorful Art Work', 'tpcore'),

                    ],
                ]
            ]
        );

        $this->add_control(
            'show_filter',
            [
                'label' => esc_html__('Show Filter', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'tpcore'),
                'label_off' => esc_html__('No', 'tpcore'),
                'separator' => 'before',
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'show_all_filter',
            [
                'label' => esc_html__('Show "All Project" Filter?', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'tpcore'),
                'label_off' => esc_html__('No', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => esc_html__('Enable to display "All Project" filter in filter menu.', 'tpcore'),
                'condition' => [
                    'show_filter' => 'yes'
                ],
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'all_filter_label',
            [
                'label' => esc_html__('Filter Label', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('All Project', 'tpcore'),
                'placeholder' => esc_html__('Type filter label', 'tpcore'),
                'description' => esc_html__('Type "All Project" filter label.', 'tpcore'),
                'condition' => [
                    'show_all_filter' => 'yes',
                    'show_filter' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        // TAB_STYLE
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'tpcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'tpcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'tpcore'),
                    'lowercase' => esc_html__('lowercase', 'tpcore'),
                    'capitalize' => esc_html__('Capitalize', 'tpcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

?>

        <?php if ($settings['tg_design_style'] == 'layout-2') :

            if (empty($settings['gallery'])) {
                return;
            }

            $categories = array();
            $cats = array();
            foreach ($settings['gallery'] as $index => $gallery) :

                $cats = explode(",", $gallery['filter']);

                foreach ($cats as $i => $cat) {
                    $categories[tp_slugify($cat)] = $cat;
                }
            endforeach;

        ?>

            <script>
                jQuery(document).ready(function($) {

                    /*=============================================
                        =    		Isotope	Active  	      =
                    =============================================*/
                    $('.project-active-two').imagesLoaded(function() {
                        // init Isotope
                        var $grid = $('.project-active-two').isotope({
                            itemSelector: '.grid-item',
                            percentPosition: true,
                            masonry: {
                                columnWidth: 1,
                            }
                        });
                        // filter items on button click
                        $('.project-menu-nav').on('click', 'button', function() {
                            var filterValue = $(this).attr('data-filter');
                            $grid.isotope({
                                filter: filterValue
                            });
                        });

                    });
                    //for menu active class
                    $('.project-menu-nav button').on('click', function(event) {
                        $(this).siblings('.active').removeClass('active');
                        $(this).addClass('active');
                        event.preventDefault();
                    });

                });
            </script>

            <div class="project-item-wrap">

                <?php if ($settings['show_filter'] === 'yes') : ?>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="project-menu-nav">
                                <?php if ($settings['show_all_filter'] === 'yes') : ?>
                                    <button class="active" data-filter="*"><?php echo esc_html($settings['all_filter_label']); ?></button>
                                <?php endif; ?>

                                <?php foreach ($categories as $key => $val) : ?>
                                    <button data-filter=".<?php echo esc_attr($key); ?>"><?php echo esc_html($val); ?></button>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="row project-active-two">
                    <?php
                    $cars = array();
                    foreach ($settings['gallery'] as $index => $gallery) :
                        $cars = explode(",",  $gallery['filter']);

                        if (!empty($gallery['tg_img']['url'])) {
                            $tg_image_url = !empty($gallery['tg_img']['id']) ? wp_get_attachment_image_url($gallery['tg_img']['id'], $gallery['tg_image_size_size']) : $gallery['tg_img']['url'];
                            $tg_image_alt = get_post_meta($gallery["tg_img"]["id"], "_wp_attachment_image_alt", true);
                        }

                        $md_class =  ($gallery['tg_gallery_col'] == 8) ? 'col-lg-8' : (($gallery['tg_gallery_col'] == 6) ? 'col-lg-6' : 'col-lg-4');
                    ?>

                        <?php foreach ($cars as $key => $value) :
                            $item_classes = tp_slugify($value);
                            $item_classes = str_replace(',', ' ', $item_classes);
                        endforeach;
                        ?>
                        <div class="<?php echo esc_attr($md_class); ?> col-md-6 grid-item <?php echo esc_attr($item_classes); ?>">
                            <div class="project-item-two">
                                <div class="project-thumb-two">
                                    <a href="<?php echo esc_url($gallery['tg_projects_url']) ?>">
                                        <img src="<?php echo esc_url($tg_image_url); ?>" alt="<?php echo esc_attr($tg_image_alt); ?>">
                                    </a>
                                </div>
                                <div class="project-content-two">
                                    <h2 class="title"><a href="<?php echo esc_url($gallery['tg_projects_url']) ?>"><?php echo tp_kses($gallery['item_title']) ?></a></h2>
                                    <span><?php echo tp_kses($gallery['tg_projects_desc']); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>

                </div>
            </div>


        <?php elseif ($settings['tg_design_style'] == 'layout-3') : ?>

            <script>
                jQuery(document).ready(function($) {

                    /*=============================================
                        =         Project Active           =
                    =============================================*/
                    if (jQuery(".project-active-three").length > 0) {
                        let courses = new Swiper(".project-active-three", {
                            slidesPerView: 0,
                            spaceBetween: 20,
                            loop: true,
                            autoplay: false,
                            breakpoints: {
                                500: {
                                    slidesPerView: 1,
                                    spaceBetween: 20,
                                },
                                768: {
                                    slidesPerView: 2,
                                    spaceBetween: 20,
                                },
                                992: {
                                    slidesPerView: 2.4,
                                    spaceBetween: 20,
                                },
                                1200: {
                                    slidesPerView: 2.7,
                                    spaceBetween: 20,
                                },
                                1500: {
                                    slidesPerView: 2.8,
                                    spaceBetween: 20,
                                },
                            },
                            // If we need pagination
                            pagination: {
                                el: ".project-swiper-pagination",
                                clickable: true,
                            },

                            // Navigation arrows
                            navigation: {
                                nextEl: ".project-button-next",
                                prevEl: ".project-button-prev",
                            },

                            // And if we need scrollbar
                            scrollbar: {
                                el: ".swiper-scrollbar",
                            },
                        });
                    }

                });
            </script>

            <div class="swiper-container project-active-three">
                <div class="swiper-wrapper">
                    <?php foreach ($settings['tg_project_list2'] as $item) :

                        if (!empty($item['tg_project_image2']['url'])) {
                            $tg_project_image_url2 = !empty($item['tg_project_image2']['id']) ? wp_get_attachment_image_url($item['tg_project_image2']['id'], $settings['project_thumb_size']) : $item['tg_project_image2']['url'];
                            $tg_project_image_alt2 = get_post_meta($item["tg_project_image2"]["id"], "_wp_attachment_image_alt", true);
                        }

                    ?>
                        <div class="swiper-slide">
                            <div class="project-item-three">

                                <div class="project-content-three">

                                    <?php if (!empty($item['tg_project_title'])) : ?>
                                        <h2 class="title"><a href="<?php echo esc_url($item['tg_project_url2']); ?>"><?php echo tp_kses($item['tg_project_title']); ?></a></h2>
                                    <?php endif; ?>

                                    <?php if (!empty($item['tg_project_desc'])) : ?>
                                        <p><?php echo tp_kses($item['tg_project_desc']); ?></p>
                                    <?php endif; ?>

                                </div>

                                <?php if (!empty($tg_project_image_url2)) : ?>
                                    <div class="project-thumb-three">
                                        <a href="<?php echo esc_url($item['tg_project_url2']); ?>">
                                            <img src="<?php echo esc_url($tg_project_image_url2); ?>" alt="<?php echo esc_attr($tg_project_image_alt2); ?>">
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($item['tg_project_url2'])) : ?>
                                    <div class="project-details-btn">
                                        <a href="<?php echo esc_url($item['tg_project_url2']); ?>">
                                            <?php echo tp_kses($item['tg_project_btn']); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

        <?php elseif ($settings['tg_design_style'] == 'layout-4') : ?>

            <script>
                jQuery(document).ready(function($) {

                    /*===========================================
                        =    Inner Project Active		      =
                    =============================================*/
                    $('.inner-project-active').slick({
                        dots: false,
                        infinite: true,
                        speed: 1000,
                        autoplay: true,
                        arrows: true,
                        prevArrow: '<button type="button" class="slick-prev"><i class="fal fa-long-arrow-left"></i></button>',
                        nextArrow: '<button type="button" class="slick-next"><i class="fal fa-long-arrow-right"></i></button>',
                        appendArrows: ".inner-project-nav",
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        centerMode: true,
                        centerPadding: '295px',
                        responsive: [{
                                breakpoint: 1600,
                                settings: {
                                    slidesToShow: 3,
                                    slidesToScroll: 1,
                                    infinite: true,
                                    centerPadding: '180px',
                                }
                            },
                            {
                                breakpoint: 1400,
                                settings: {
                                    slidesToShow: 3,
                                    slidesToScroll: 1,
                                    infinite: true,
                                    centerPadding: '100px',
                                }
                            },
                            {
                                breakpoint: 1200,
                                settings: {
                                    slidesToShow: 3,
                                    slidesToScroll: 1,
                                    infinite: true,
                                    centerPadding: '40px',
                                }
                            },
                            {
                                breakpoint: 992,
                                settings: {
                                    slidesToShow: 2,
                                    slidesToScroll: 1,
                                    centerPadding: '40px',
                                }
                            },
                            {
                                breakpoint: 767,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1,
                                    arrows: false,
                                    centerPadding: '20px',
                                }
                            },
                            {
                                breakpoint: 575,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1,
                                    arrows: false,
                                    centerPadding: '0px',
                                }
                            },
                        ]
                    });

                });
            </script>

            <div class="inner-projcet-wrap-two">
                <div class="row g-0 inner-project-active">
                    <?php foreach ($settings['tg_project_list'] as $item) :

                        if (!empty($item['tg_project_image']['url'])) {
                            $tg_project_image_url = !empty($item['tg_project_image']['id']) ? wp_get_attachment_image_url($item['tg_project_image']['id'], $settings['thumbnail_size']) : $item['tg_project_image']['url'];
                            $tg_project_image_alt = get_post_meta($item["tg_project_image"]["id"], "_wp_attachment_image_alt", true);
                        }

                        if (!empty($item['tg_project_image02']['url'])) {
                            $tg_project_bottom_url = !empty($item['tg_project_image02']['id']) ? wp_get_attachment_image_url($item['tg_project_image02']['id'], $settings['thumbnail_size']) : $item['tg_project_image02']['url'];
                            $tg_project_bottom_alt = get_post_meta($item["tg_project_image02"]["id"], "_wp_attachment_image_alt", true);
                        }

                    ?>

                        <div class="col-lg-4">
                            <div class="inner-project-item horizoital-item">
                                <div class="inner-project-thumb">
                                    <a href="<?php echo esc_url($item['tg_project_url']); ?>">
                                        <img src="<?php echo esc_url($tg_project_image_url); ?>" alt="<?php echo esc_attr($tg_project_image_alt); ?>">
                                    </a>
                                </div>
                                <?php if ($item['tg_project_style'] == 'layout-2') : ?>
                                    <div class="inner-project-content">
                                        <h3 class="title">
                                            <a href="<?php echo esc_url($item['tg_project_url']); ?>"><?php echo tp_kses($item['tg_title_top']) ?></a>
                                        </h3>
                                        <p><?php echo tp_kses($item['tg_desc_top']) ?></p>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php if ($item['tg_project_style'] == 'layout-2') : ?>
                                <div class="inner-project-item vertical-item">
                                    <div class="inner-project-thumb">
                                        <a href="<?php echo esc_url($item['tg_url_bottom']); ?>">
                                            <img src="<?php echo esc_url($tg_project_bottom_url); ?>" alt="<?php echo esc_attr($tg_project_bottom_alt); ?>">
                                        </a>
                                    </div>
                                    <div class="inner-project-content">
                                        <h3 class="title">
                                            <a href="<?php echo esc_url($item['tg_url_bottom']); ?>"><?php echo tp_kses($item['tg_title_bottom']) ?></a>
                                        </h3>
                                        <p><?php echo tp_kses($item['tg_desc_bottom']) ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                    <?php endforeach; ?>
                </div>
            </div>

        <?php else : ?>

            <script>
                jQuery(document).ready(function($) {

                    /*===========================================
                        =         Project Active           =
                    =============================================*/
                    if (jQuery(".project-active").length > 0) {
                        let courses = new Swiper(".project-active", {
                            slidesPerView: 1,
                            spaceBetween: 20,
                            loop: true,
                            autoplay: false,
                            breakpoints: {
                                500: {
                                    slidesPerView: 1,
                                    spaceBetween: 20,
                                },
                                768: {
                                    slidesPerView: 2.2,
                                    spaceBetween: 20,
                                },
                                992: {
                                    slidesPerView: 3,
                                    spaceBetween: 20,
                                },
                                1200: {
                                    slidesPerView: 3.4,
                                    spaceBetween: 20,
                                },
                                1500: {
                                    slidesPerView: 3.3,
                                    spaceBetween: 20,
                                },
                            },
                            // If we need pagination
                            pagination: {
                                el: ".project-swiper-pagination",
                                clickable: true,
                            },

                            // Navigation arrows
                            navigation: {
                                nextEl: ".swiper-button-next",
                                prevEl: ".swiper-button-prev",
                            },

                            // And if we need scrollbar
                            scrollbar: {
                                el: ".swiper-scrollbar",
                            },
                        });
                    }

                });
            </script>

            <div class="project-item-wrap">
                <div class="swiper-container project-active">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['tg_project_list'] as $item) :

                            if (!empty($item['tg_project_image']['url'])) {
                                $tg_project_image_url = !empty($item['tg_project_image']['id']) ? wp_get_attachment_image_url($item['tg_project_image']['id'], $settings['thumbnail_size']) : $item['tg_project_image']['url'];
                                $tg_project_image_alt = get_post_meta($item["tg_project_image"]["id"], "_wp_attachment_image_alt", true);
                            }

                        ?>
                            <div class="swiper-slide">
                                <div class="project-item">
                                    <a href="<?php echo esc_url($item['tg_project_url']); ?>">
                                        <img src="<?php echo esc_url($tg_project_image_url); ?>" alt="<?php echo esc_attr($tg_project_image_alt); ?>">
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

        <?php endif; ?>

<?php
    }
}

$widgets_manager->register(new TG_Project());
