<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;

use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Background;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Xolio Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_Fact extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tp-fact';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Fact', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tg_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                    'layout-2' => esc_html__('Layout 2', 'tpcore'),
                    'layout-3' => esc_html__('Layout 3', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // Fact group
        $this->start_controls_section(
            'tg_fact',
            [
                'label' => esc_html__('Fact List', 'tpcore'),
                'description' => esc_html__('Control all the style settings from Style tab', 'tpcore'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tg_design_style' => 'layout-1'
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tg_fact_number',
            [
                'label' => esc_html__('Number', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('535', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tg_fact_desc',
            [
                'label' => esc_html__('Fact Description', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Project Completed', 'tpcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_fact_list',
            [
                'label' => esc_html__('Fact Lists', 'tpcore'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tg_fact_number' => esc_html__('535', 'tpcore'),
                        'tg_fact_desc' => esc_html__('Project Completed', 'tpcore'),
                    ],
                    [
                        'tg_fact_number' => esc_html__('922', 'tpcore'),
                        'tg_fact_desc' => esc_html__('Our Happy Clients', 'tpcore'),
                    ],
                    [
                        'tg_fact_number' => esc_html__('954', 'tpcore'),
                        'tg_fact_desc' => esc_html__('Cup of Coffee for Me', 'tpcore'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // Fact group 02
        $this->start_controls_section(
            'tg_fact2',
            [
                'label' => esc_html__('Fact List', 'tpcore'),
                'description' => esc_html__('Control all the style settings from Style tab', 'tpcore'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tg_design_style' => ['layout-2', 'layout-3']
                ]
            ]
        );

        $repeater2 = new \Elementor\Repeater();

        $repeater2->add_control(
            'tg_icon_type2',
            [
                'label' => esc_html__('Select Icon Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'tpcore'),
                    'icon' => esc_html__('Icon', 'tpcore'),
                ],
            ]
        );

        $repeater2->add_control(
            'tg_svg2',
            [
                'label' => esc_html__('Upload Icon', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tg_icon_type2' => 'image'
                ]
            ]
        );

        if (tp_is_elementor_version('<', '2.6.0')) {
            $repeater2->add_control(
                'tg_icon2',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'tg_icon_type2' => 'icon'
                    ]
                ]
            );
        } else {
            $repeater2->add_control(
                'tg_selected_icon2',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'tg_icon_type2' => 'icon'
                    ]
                ]
            );
        }

        $repeater2->add_control(
            'tg_fact_number2',
            [
                'label' => esc_html__('Number', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('535', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater2->add_control(
            'tg_fact_formatting2',
            [
                'label' => esc_html__('Formatting Mask', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('+', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater2->add_control(
            'tg_fact_desc2',
            [
                'label' => esc_html__('Fact Description', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Project Completed', 'tpcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_fact_list2',
            [
                'label' => esc_html__('Fact Lists', 'tpcore'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater2->get_controls(),
                'default' => [
                    [
                        'tg_fact_number2' => esc_html__('535', 'tpcore'),
                        'tg_fact_desc2' => esc_html__('Project Completed', 'tpcore'),
                    ],
                    [
                        'tg_fact_number2' => esc_html__('922', 'tpcore'),
                        'tg_fact_desc2' => esc_html__('Our Happy Clients', 'tpcore'),
                    ],
                    [
                        'tg_fact_number2' => esc_html__('954', 'tpcore'),
                        'tg_fact_desc2' => esc_html__('Cup of Coffee for Me', 'tpcore'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // TAB_STYLE
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'tpcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'tpcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'tpcore'),
                    'lowercase' => esc_html__('lowercase', 'tpcore'),
                    'capitalize' => esc_html__('Capitalize', 'tpcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <script>
            jQuery(document).ready(function($) {

                /*=============================================
                    =    		Odometer Active  	       =
                =============================================*/
                $('.odometer').appear(function(e) {
                    var odo = $(".odometer");
                    odo.each(function() {
                        var countNumber = $(this).attr("data-count");
                        $(this).html(countNumber);
                    });
                });

            });
        </script>

        <?php if ($settings['tg_design_style']  == 'layout-2') : ?>

            <div class="counter-item-wrap-two">
                <ul class="list-wrap">
                    <?php foreach ($settings['tg_fact_list2'] as $item) : ?>
                        <li>
                            <div class="counter-item-two">
                                <div class="icon">
                                    <?php if ($item['tg_icon_type2'] !== 'image') : ?>
                                        <?php if (!empty($item['tg_icon2']) || !empty($item['tg_selected_icon2']['value'])) : ?>
                                            <?php tp_render_icon($item, 'tg_icon2', 'tg_selected_icon2'); ?>
                                        <?php endif; ?>
                                    <?php else : ?>
                                        <?php if(!empty($item['tg_svg2']['url'])) : ?>
                                            <img src="<?php echo esc_url($item['tg_svg2']['url']); ?>" alt="<?php echo esc_html__('Icon', 'tpcore') ?>">
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                                <div class="content">
                                    <span class="count odometer" data-count="<?php echo tp_kses($item['tg_fact_number2']); ?>"></span>
                                    <?php if (!empty($item['tg_fact_desc2'])) : ?>
                                        <p><?php echo tp_kses($item['tg_fact_desc2']); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>

        <?php elseif ($settings['tg_design_style']  == 'layout-3') : ?>

            <div class="counter-item-wrap-three">
                <ul class="list-wrap">
                    <?php foreach ($settings['tg_fact_list2'] as $item) : ?>
                        <li>
                            <div class="counter-item-three">
                                <div class="icon">
                                    <?php if ($item['tg_icon_type2'] !== 'image') : ?>
                                        <?php if (!empty($item['tg_icon2']) || !empty($item['tg_selected_icon2']['value'])) : ?>
                                            <?php tp_render_icon($item, 'tg_icon2', 'tg_selected_icon2'); ?>
                                        <?php endif; ?>
                                    <?php else : ?>
                                        <?php if(!empty($item['tg_svg2']['url'])) : ?>
                                            <img src="<?php echo esc_url($item['tg_svg2']['url']); ?>" alt="<?php echo esc_html__('Icon', 'tpcore') ?>">
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                                <div class="content">
                                    <h2 class="count"><span class="odometer" data-count="<?php echo tp_kses($item['tg_fact_number2']); ?>"></span><?php if (!empty($item['tg_fact_formatting2'])) : ?><?php echo tp_kses($item['tg_fact_formatting2']); ?><?php endif; ?></h2>
                                    <?php if (!empty($item['tg_fact_desc2'])) : ?>
                                        <p><?php echo tp_kses($item['tg_fact_desc2']); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>

        <?php else : ?>

            <div class="counter-item-wrap">
                <div class="row">
                    <?php foreach ($settings['tg_fact_list'] as $item) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="counter-item">
                                <span class="count odometer" data-count="<?php echo tp_kses($item['tg_fact_number']); ?>"></span>
                                <?php if (!empty($item['tg_fact_desc'])) : ?>
                                    <p><?php echo tp_kses($item['tg_fact_desc']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

        <?php endif; ?>

<?php
    }
}

$widgets_manager->register(new TG_Fact());
