<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Xolio Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_Advanced_Tab extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'advanced-tab';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Advanced Tab', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'tg_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tg_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                    'layout-2' => esc_html__('Layout 2', 'tpcore'),
                    'layout-3' => esc_html__('Layout 3', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // ADVANCE TAB
        $this->start_controls_section(
            '_section_price_tabs',
            [
                'label' => esc_html__('Advanced Tabs', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Title', 'tpcore'),
                'default' => esc_html__('Tab Title', 'tpcore'),
                'label_block' => true,
                'placeholder' => esc_html__('Type Tab Title', 'tpcore'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'template',
            [
                'label' => esc_html__('Section Template', 'tpcore'),
                'placeholder' => esc_html__('Select a section template for as tab content', 'tpcore'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => get_elementor_templates()
            ]
        );

        $this->add_control(
            'tabs',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{title}}',
                'default' => [
                    [
                        'title' => 'Tab 1',
                    ],
                    [
                        'title' => 'Tab 2',
                    ]
                ]
            ]
        );

        $this->add_responsive_control(
            'tp_align',
            [
                'label' => esc_html__('Alignment', 'tpcore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'tpcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'tpcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'tpcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => false,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ],
                'condition' => [
                    'tg_design_style' => 'layout-1'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'tpcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'tpcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'tpcore'),
                    'lowercase' => esc_html__('lowercase', 'tpcore'),
                    'capitalize' => esc_html__('Capitalize', 'tpcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <?php if ($settings['tg_design_style'] == 'layout-2') : ?>

            <section class="project-area-three">
                <div class="container">
                    <div class="project-nav-wrap">
                        <div class="row">
                            <div class="col-xl-2">
                                <div class="project-tab-wrap">
                                    <ul class="nav nav-tabs" id="projectTab" role="tablist">

                                        <?php $flag = true;
                                        foreach ($settings['tabs'] as $key => $tab) :
                                            $active = ($key == 0) ? 'active' : '';
                                        ?>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link <?php echo esc_attr($active); ?>" id="tg-tab-<?php echo esc_attr($key); ?>" data-bs-toggle="tab" data-bs-target="#tg-id-<?php echo esc_attr($key); ?>" type="button" role="tab" aria-controls="tg-id-<?php echo esc_attr($key); ?>" aria-selected="true"><?php echo tp_kses($tab['title']); ?></button>
                                            </li>
                                        <?php $flag = false;
                                        endforeach; ?>

                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-10">
                                <div class="tab-content" id="projectTabContent">

                                    <?php foreach ($settings['tabs'] as $key => $tab) :
                                        $active = ($key == 0) ? 'show active' : '';
                                    ?>
                                        <div class="tab-pane fade <?php echo esc_attr($active); ?>" id="tg-id-<?php echo esc_attr($key); ?>" role="tabpanel" aria-labelledby="tg-tab-<?php echo esc_attr($key); ?>" tabindex="0">
                                            <?php echo \Elementor\Plugin::instance()->frontend->get_builder_content($tab['template'], true); ?>
                                        </div>
                                    <?php endforeach; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php elseif ($settings['tg_design_style'] == 'layout-3') : ?>

            <div class="developr-content">
                <ul class="nav nav-tabs" id="developerTab" role="tablist">
                    <?php $flag = true;
                    foreach ($settings['tabs'] as $key => $tab) :
                        $active = ($key == 0) ? 'active' : '';
                    ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php echo esc_attr($active); ?>" id="tg-tab-<?php echo esc_attr($key); ?>" data-bs-toggle="tab" data-bs-target="#tg-id-<?php echo esc_attr($key); ?>" type="button" role="tab" aria-controls="tg-id-<?php echo esc_attr($key); ?>" aria-selected="true"><?php echo tp_kses($tab['title']); ?></button>
                        </li>
                    <?php $flag = false;
                    endforeach; ?>
                </ul>
                <div class="tab-content" id="developerTabContent">

                    <?php foreach ($settings['tabs'] as $key => $tab) :
                        $active = ($key == 0) ? 'show active' : '';
                    ?>
                        <div class="tab-pane fade <?php echo esc_attr($active); ?>" id="tg-id-<?php echo esc_attr($key); ?>" role="tabpanel" aria-labelledby="tg-tab-<?php echo esc_attr($key); ?>" tabindex="0">
                            <?php echo \Elementor\Plugin::instance()->frontend->get_builder_content($tab['template'], true); ?>
                        </div>
                    <?php endforeach; ?>

                </div>
            </div>

        <?php else : ?>

            <div class="pricing-item-wrap">
                <div class="pricing-tab">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <?php $flag = true;
                        foreach ($settings['tabs'] as $key => $tab) :
                            $active = ($key == 0) ? 'active' : '';
                        ?>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php echo esc_attr($active); ?>" id="tg-tab-<?php echo esc_attr($key); ?>" data-bs-toggle="tab" data-bs-target="#tg-id-<?php echo esc_attr($key); ?>" type="button" role="tab" aria-controls="tg-id-<?php echo esc_attr($key); ?>" aria-selected="true"><?php echo tp_kses($tab['title']); ?></button>
                            </li>
                        <?php $flag = false;
                        endforeach; ?>
                    </ul>
                </div>
                <div class="tab-content" id="myTabContent">
                    <?php foreach ($settings['tabs'] as $key => $tab) :
                        $active = ($key == 0) ? 'show active' : '';
                    ?>
                        <div class="tab-pane <?php echo esc_attr($active); ?>" id="tg-id-<?php echo esc_attr($key); ?>" role="tabpanel" aria-labelledby="tg-tab-<?php echo esc_attr($key); ?>" tabindex="0">
                            <?php echo \Elementor\Plugin::instance()->frontend->get_builder_content($tab['template'], true); ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

        <?php endif; ?>

<?php
    }
}
$widgets_manager->register(new TG_Advanced_Tab());
